//: A UIKit based Playground for presenting user interface
  
import UIKit
import PlaygroundSupport

enum Size: Int, CaseIterable {
    case S = 0
    case M
    case L
    case XL
}

class MyViewController : UIViewController {
    override func loadView() {
        let view = UIView()
        view.backgroundColor = .white

        print(Size.allCases.count)
        let control = UISegmentedControl(items: Size.allCases.map({ "\($0)" }))
        
        control.addTarget(self, action: #selector(segmentChanged(sender:)), for: .valueChanged)
        
        control.frame = CGRect(x: 20, y: 200, width: 340, height: 20)
        view.addSubview(control)
        self.view = view
    }
    
    @objc func segmentChanged(sender: UISegmentedControl) {
        let index = sender.selectedSegmentIndex
        print(Size(rawValue: index)!)
    }
}
// Present the view controller in the Live View window
PlaygroundPage.current.liveView = MyViewController()
